/*****************************************************************************
*  LPC15xx SCT0 dithering demo
*
*  LPC154x  - SCT0/1 support:  8 inputs
*                              10 outputs
*                              16 match/capture registers
*                              16 events
*                              16 states
*             SCT2/3 support:  3 inputs
*                              6 outputs
*                              8 match/capture registers
*                              10 events
*                              10 states
*****************************************************************************/
#include "LPC15xx.h"

/////////
// SystemCoreClock = IRC / 48 = 250KHz (set in system_LPC15xx.c)
/////////

void SCT0_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |=  (EN1_SCT0);             // enable the SCT0 clock

    LPC_SCT0->CONFIG           |= (1 << 0) | (1 << 17);    // unified timer and autolimit
    LPC_SCT0->CTRL_U           |= (249 << 5);              // SCT0 clock input is 12MHZ/(249+1) = 1KHz (1msec)

    LPC_SCT0->MATCH[0].U        = 4-1;                     // match 0 @ 4 msec
    LPC_SCT0->MATCHREL[0].U     = 4-1;
    LPC_SCT0->MATCH[1].U        = 1-1;                     // match 1 @ 1 msec
    LPC_SCT0->MATCHREL[1].U     = 1-1;

    LPC_SCT0->EVENT[0].STATE    = 0x0000000F;              // event 0 happens in all states
    LPC_SCT0->EVENT[0].CTRL     = (0 << 0)  |              // related to match 0
                                  (1 << 12) |              // COMBMODE[13:12] = match condition only
                                  (1 << 14) |              // STATELD[14] = STATEV is loaded into state
                                  (0 << 15);               // STATEV[15] = 0

    LPC_SCT0->EVENT[1].STATE    = 0x0000000F;              // event 1 happens in all states
    LPC_SCT0->EVENT[1].CTRL     = (1 << 0)  |              // related to match 1
                                  (1 << 12) |              // COMBMODE[13:12] = match condition only
                                  (1 << 14) |              // STATELD[14] = STATEV is loaded into state
                                  (0 << 15);               // STATEV[15] = 0

    LPC_SCT0->OUT[0].SET        = (1 << 0);                // event 0 will set SCT0_OUT_0
    LPC_SCT0->OUT[0].CLR        = (1 << 1);                // event 1 will clear SCT0_OUT_0

    LPC_SCT0->CTRL_U           &= ~(1 << 2);               // unhalt it by clearing bit 2 of the CTRL register
}
